/*
	This is a part of the source code for Pro/DESKTOP.
	Copyright (C) 1998-1999 Parametric Technology Corporation.
	All rights reserved.
*/

//	OrientedPlane.cpp

#include <stdafx.h>

#include "cUtility.h"
#include "CWorkplane.h"
#include "cApplication.h"

// Creates a Oriented Plane with the specified angle and return the 
// Oriented workplane

HRESULT Orientedplane(ITopology *pedge,double angle,CString workplaneName,CString sketchName,VARIANT_BOOL bNoSketch,long color,IWorkplane **retDispatch)
{

	START_METHOD("Orientedplane")

	HRESULT status = CONV_SUCCESS;

	IGraphicDocument *activeGraphicDoc = NULL;
	IPartDocument *activePart = NULL;
	IWorkplane *activeWorkplane = NULL;
	ISketch *activeSketch = NULL;
	IDispatch *pDisp = NULL;
	IWorkplane *porientedplane = NULL;

	// check if the selected edge belongs to an EdgeClass
	VARIANT_BOOL blnEdge;
	IObject *object = NULL;

	CHECK_VAR_STATUS(pedge)

	object = CAST(IObject, pedge);

	status = object->IsA(GetBSTR("Edge"),&blnEdge);
	CHECK_RETURN_STATUS(status)

	if(blnEdge) {

		status = GetActivePartWorkplaneSketch(&activePart, &activeGraphicDoc, &activeWorkplane, &activeSketch);
		CHECK_RETURN_STATUS(status)

		IDesign *pDesign= NULL;
		status = activePart->GetDesign(&pDesign);

		IGeometric *pEdge= CAST(IGeometric, pedge);

		IGeometry *pEdgeGeom= NULL;
		status = pEdge->GetGeometricForm(&pEdgeGeom);
		CHECK_RETURN_STATUS(status)

		IGeometric *pPlaneGeom= CAST(IGeometric, activeWorkplane);

		// get the geometry
		IGeometry *pPlane = NULL;
		status = pPlaneGeom->GetGeometry(&pPlane);
		CHECK_RETURN_STATUS(status)
    
		// Create a Parallel Plane
		IGeometry *pcEdgeGeom = NULL;
		status = pEdgeGeom->Clone(&pcEdgeGeom);
		CHECK_RETURN_STATUS(status)

		IGeometry  *pcPlane = NULL;
		status = pPlane->Clone(&pcPlane);
		CHECK_RETURN_STATUS(status)

		IParallelPlane  *pOffSet = NULL;
  		status = (GetCLASS(ParallelPlane))->CreateParallelPlane(pcEdgeGeom, CAST(IPlane, pcPlane), 1, &pOffSet);
		CHECK_RETURN_STATUS(status)
		// Create an Angled Plane
		IAngledPlane *pAngledPlane = NULL;
		status = (GetCLASS(AngledPlane))->CreateAngledPlane(pcEdgeGeom, CAST(IPlane, pOffSet), angle, 1, &pAngledPlane);

		pDesign->CreateWorkplane(CAST(IPlane, pAngledPlane), workplaneName.AllocSysString(), &porientedplane);

		// Create a sketch with the given sketch name
		ISketch *pSketch = NULL;
		if(!bNoSketch)
		{

			status = porientedplane->CreateSketch(sketchName.AllocSysString(), &pSketch);
			CHECK_RETURN_STATUS(status)

			status = activeGraphicDoc->SetActiveSketch(pSketch);
			CHECK_RETURN_STATUS(status)

			// Set the color for the sketch
			IColor *pNewColor= NULL;
			if(color<0 || color > 11)
				color = 4;

			status = (GetCLASS(Color))->CreateColor(1, color*30, 0.35, 1, &pNewColor);
			CHECK_RETURN_STATUS(status)

			status = pSketch->SetColor(pNewColor);
			CHECK_RETURN_STATUS(status)
		}
   	}
	else {
		AfxMessageBox ("Improper Selection of Entity");
		porientedplane = NULL;
	}

	*retDispatch=porientedplane;
    END_METHOD("Orientedplane")
}
